%{
	#include <string.h>
	#include <stdio.h>
	#include "lexems.h"

	extern int l_linenum;
	extern int l_posnum;

%}

DIGIT	[0-9]
ID	[a-zA_Z][a-zA-Z0-9_]*

	l_linenum = 1;
	l_posnum = 1;

%%

secrets	{ l_result = L_SECRETS; l_posnum += yyleng; return 1; }

end	{ l_result = L_END; l_posnum += yyleng; return 1; }

keys	{ l_result = L_KEYS; l_posnum += yyleng; return 1; }

if	{ l_result = L_IF; l_posnum += yyleng; return 1; }

then	{ l_result = L_THEN; l_posnum += yyleng; return 1; }

else	{ l_result = L_ELSE; l_posnum += yyleng; return 1; }

while	{ l_result = L_WHILE; l_posnum += yyleng; return 1; }

do	{ l_result = L_DO; l_posnum += yyleng; return 1; }

=	{ l_result = L_EQUALS; l_posnum += yyleng; return 1; }

enc	{ l_result = L_FUNCTION; l_opsort = O_ENC; l_posnum += yyleng; return 1; }

key_gen	{ l_result = L_FUNCTION; l_opsort = O_KEYGEN; l_posnum += yyleng; return 1; }

\(	{ l_result = L_OPEN; l_posnum += yyleng; return 1; }

\)	{ l_result = L_CLOSE; l_posnum += yyleng; return 1; }

,	{ l_result = L_COMMA; l_posnum += yyleng; return 1; }

;	{ l_result = L_SEMICOLON; l_posnum += yyleng; return 1; }

`{ID}	{ l_result = L_FUNCTION; l_opsort = O_NORMAL; l_posnum += yyleng;
          if( yyleng > l_idnamebuflen )
	  {
	    int i;
	    
	    printf("Function name is too long: ");
	    for(i=0; i<yyleng; i++)
	      putchar(yytext[i]);
	    putchar('\n');
	    l_result = L_ERROR;
	  }
          strncpy(l_idname, yytext+1, yyleng-1);
          l_idname[yyleng-1] = '\0';
          return 1; }

{ID}	{ l_result = L_VARIABLE; l_posnum += yyleng;
          if( yyleng >= l_idnamebuflen )
	  {
	    int i;
	    
	    printf("Variable name is too long: ");
	    for(i=0; i<yyleng; i++)
	      putchar(yytext[i]);
	    putchar('\n');
	    l_result = L_ERROR;
	  }
          strncpy(l_idname, yytext, yyleng);
          l_idname[yyleng] = '\0';
          return 1; }

{DIGIT}+ { l_result = L_CONSTANT; l_posnum += yyleng;
          if( yyleng >= l_idnamebuflen )
	  {
	    int i;
	    
	    printf("Constant name is too long: ");
	    for(i=0; i<yyleng; i++)
	      putchar(yytext[i]);
	    putchar('\n');
	    l_result = L_ERROR;
	  }
          strncpy(l_idname, yytext, yyleng);
          l_idname[yyleng] = '\0';
          return 1; }

<<EOF>>	{ l_result = L_EOF; return 1; }

\n	{ ++l_linenum; l_posnum = 1; }

[ \t]+	{ l_posnum += yyleng;  }

.	{ ++l_posnum; l_result = L_ERROR; return 1; }
