#ifndef _CFGSTR_H
#define _CFGSTR_H

#include <bdduser.h>

typedef int bool;
#define TRUE 1
#define FALSE 0

typedef enum nodeType_enum {N_ASSIGN, N_BRANCH, N_MERGE,
                            N_START, N_END} NodeType;
typedef enum edgeType_enum {E_NORMAL, E_TRUE, E_FALSE} EdgeType;
typedef enum operSort_enum {O_NORMAL, O_ASSIGN, O_ENC, O_KEYGEN} OperSort;

typedef
struct
  varType_str {
    bool isConst;
    bool isPseudo;
    char *name;
    char *lpcfname;
    char *rpcfname;
    int index;
    bdd pcf;
    bdd lpcf;
    bdd rpcf;
    bdd lorrpcf;
    bdd landrpcf;
    struct varType_str *nextprim;
  }
VarType;

typedef
struct
  operType_str {
    OperSort sort;
    char *name;
    struct operType_str *nextprim;
  }
OperType;

typedef
struct
  varList_str {
    VarType *var;
    struct varList_str *next;
  }
VarList;

typedef
struct
  cfgNode_str {
    int id;
    NodeType ntype;
    union {
      struct {
        VarType *lhs;
        OperType *oper;
        VarList *rhs;
      } forAsgn;
      struct {
        VarType *checked;
        VarType *pseudo;
      } forBranch;
      struct {
        struct cfgNode_str *corresp;
        VarList *changes;
      } forMerge;
    } specific;
    struct cfgNode_str *contrdep;
    struct cfgEdge_str *edges;
    struct cfgNode_str *next;
  }
CfgNode;

typedef
struct
  analResult_str {
    bool *good_keys;
    bdd bkeys;
    bdd bsecs;
  }
AnalResult;

typedef
struct
  cfgEdge_str {
    EdgeType etype;
    bool isbackedge;
    CfgNode *target;
    struct cfgEdge_str *next;
    AnalResult *anres;
  }
CfgEdge;

typedef
struct
  workList_str {
    CfgEdge *edge;
    struct workList_str *next;
  }
WorkList;

#endif
